using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            TPDFRect bbox;
            int gs, grp, sh;
            TPDFExtGState g;
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            // Disable color key masking for images
            pdf.SetUseTransparency(false);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();

               pdf.SetFont("Helvetica", TFStyle.fsRegular, 12.0, false, TCodepage.cp1252);
               pdf.WriteText(50.0, 50.0, "Transparency effect with a soft mask.");

               pdf.InsertImageEx(50.0, 80.0, pdf.GetPageWidth() - 100.0, 0.0, "../../../../test_files/images/meadow-110719_640.jpg", 1);

               // Note that a transparency group that it used as soft mask has no own coordinate system. The esiest way to avoid coordinate
               // issues is to create the transparency group in the full size of the page or template in which it is used. The real bounding
               // box can be computed after the transparency group was fully defined.
               grp = pdf.BeginTransparencyGroup(0.0, 0.0, pdf.GetPageWidth(), pdf.GetPageHeight(), true, false, TExtColorSpace.esDeviceGray, -1);
                  pdf.SetColorSpace(TPDFColorSpace.csDeviceGray);
                  sh = pdf.CreateRadialShading(400.0, 230.0, 20.0, 400.0, 230.0, 150.0, 1.0, 255, 0, true, false);
                  pdf.ApplyShading(sh);
                  // Optional but recommended: Compute the real bounding of the group if it is used as soft mask.
                  bbox = new TPDFRect();
                  pdf.ComputeBBox(ref bbox, TCompBBoxFlags.cbfNone);
                  pdf.SetBBox(TPageBoundary.pbMediaBox, bbox.Left, bbox.Bottom, bbox.Right, bbox.Top);
               pdf.EndTemplate();

               g = new TPDFExtGState();
               pdf.InitExtGState(ref g);
               g.SoftMask = pdf.CreateSoftMask(grp, TSoftMaskType.smtLuminosity, 0);
               gs = pdf.CreateExtGState(ref g);

               pdf.SetExtGState(gs);
               pdf.InsertImageEx(220.0, 80.0, 500.0, 0.0, "../../../../test_files/images/tree-frog-69813_640.jpg", 1);

            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
